using System;
using System.Text;

class Solution
{
    static void Main()
    {
        string linija = Console.ReadLine();
        if (linija == null) return;
        int n = int.Parse(linija.Trim());
        int[] pomX = new int[n];
        int[] pomY = new int[n];
        for (int i = 0; i < n; i++)
        {
            string[] podela = Console.ReadLine().Split(new[] { ' ', '\t' }, StringSplitOptions.RemoveEmptyEntries);
            pomX[i] = int.Parse(podela[0]);
            pomY[i] = int.Parse(podela[1]);
        }

        int[] poredak = new int[n];
        for (int i = 0; i < n; i++) poredak[i] = i;

        int[] najboljiIndeksi = new int[n];
        int brojNajboljih = 0;
        long najboljiKvadrat = -1;

        Random slucajni = new Random();
        int ITER = 8;
        int[] trenutniIndeksi = new int[n];

        for (int it = 0; it < ITER; it++)
        {
            for (int i = n - 1; i > 0; i--)
            {
                int j = slucajni.Next(i + 1);
                int t = poredak[i];
                poredak[i] = poredak[j];
                poredak[j] = t;
            }

            long curX = 0;
            long curY = 0;
            long curSq = 0;
            int curCount = 0;

            for (int ii = 0; ii < n; ii++)
            {
                int idx = poredak[ii];
                long nx = curX + pomX[idx];
                long ny = curY + pomY[idx];
                long nsq = nx * nx + ny * ny;
                if (nsq > curSq)
                {
                    curX = nx;
                    curY = ny;
                    curSq = nsq;
                    trenutniIndeksi[curCount++] = idx + 1;
                }
            }

            if (curSq > najboljiKvadrat)
            {
                najboljiKvadrat = curSq;
                brojNajboljih = curCount;
                for (int k = 0; k < curCount; k++) najboljiIndeksi[k] = trenutniIndeksi[k];
            }
        }

        for (int i = 0; i < n; i++)
        {
            long sq = (long)pomX[i] * pomX[i] + (long)pomY[i] * pomY[i];
            if (sq > najboljiKvadrat)
            {
                najboljiKvadrat = sq;
                brojNajboljih = 1;
                najboljiIndeksi[0] = i + 1;
            }
        }

        long sveX = 0;
        long sveY = 0;
        for (int i = 0; i < n; i++) { sveX += pomX[i]; sveY += pomY[i]; }
        long sveSq = sveX * sveX + sveY * sveY;
        if (sveSq > najboljiKvadrat)
        {
            najboljiKvadrat = sveSq;
            brojNajboljih = n;
            for (int i = 0; i < n; i++) najboljiIndeksi[i] = i + 1;
        }

        Console.WriteLine(brojNajboljih);
        if (brojNajboljih > 0)
        {
            StringBuilder izlaz = new StringBuilder();
            for (int i = 0; i < brojNajboljih; i++)
            {
                if (i > 0) izlaz.Append(' ');
                izlaz.Append(najboljiIndeksi[i]);
            }
            Console.WriteLine(izlaz.ToString());
        }
    }
}